#pragma rtGlobals=3		// Use modern global access method and strict wave access.

Menu "Plot&Fit"
		"BET BJH Panel ", GasAdsorptionPanel()
end

Function GasAdsorptionPanel()
	IN2G_CheckScreenSize("height",670)
	DoWindow/R GasAdsorptionPanl	
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists ("root:Packages:GasAdsorptionTool"))
		Newdatafolder root:Packages:GasAdsorptionTool
	endif
	variable/g root:Packages:GasAdsorptionTool:GraphLogY=0,root:Packages:GasAdsorptionTool:GraphLogX=0	
	variable/g root:Packages:GasAdsorptionTool:ErrorMultiplier=0.0002,root:Packages:GasAdsorptionTool:GraphErrors=0,root:Packages:GasAdsorptionTool:STP=1
	string/g root:Packages:GasAdsorptionTool:IntensityWaveName="---"
	variable/g root:Packages:GasAdsorptionTool:GraphLogX=0
	Variable/g Root:Packages:GasAdsorptionTool:UseDR=1
	Variable/g Root:Packages:GasAdsorptionTool:UsePV=1

	
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, 1}
	yavedata={ 0, 1000}
	Plotadsorption("yavedata","xavedata", "")
	setAxis bottom 0, 1
	SetAxis/A left
	removefromgraph yavedata
	textBox/K/N=text0
end

Function Plotadsorption(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K AdsorptionGraph
	Display/K=1/N=AdsorptionGraph/W=(1.0*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),26*IN2G_ScreenWidthHeight("width"),50*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 170
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=14, fstyle=0, Title="Gas Adsorption",Labelback=0, POS={170,2},Size={100,10}	
	variable YPOS=130, XPOS
	Button PlotAdsData,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="PlotDATA"		
	
  	Button RemoveAdsTrace,pos={60,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="RemoveTrace"
  	Button BJH,pos={120,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="BJH+KJS"	
  	Button alphaS,pos={180,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Alpha-S"		
	Button BETButton, Pos={241,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="BET"	
	Button Loadtext, Pos={0,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Load .txt"	  	
  	Button Tristar, Pos={61,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Load tristar"	
  	 Button ASAP, Pos={121,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Load ASAP"	
  	 Button ASAPDist, Pos={180,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="ASAP Dist"
  	 Button tplot, Pos={182,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="t-plot"
  	 Button BdBFHHButton, Pos={242,YPOS+20},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="BdB-FHH"
  	Button generrors,pos={300,6},size={60,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="GenErrors"
  	SetVariable ErrorMult, pos={300,23}, size={100,20},title="Multiplier", proc=DWS_Ads_SetVariableControl
	SetVariable ErrorMult, limits={-inf,Inf,0.005},value= root:Packages:GasAdsorptionTool:ErrorMultiplier
	
	//CheckBox BJHpick pos={40,2},title="BJH", variable= root:Packages:GasAdsorptionTool:BJHpick, proc=DWS_Ads_CheckBox, value=0
	CheckBox GraphLogY pos={325,YPOS},title="Log Y?", variable= root:Packages:GasAdsorptionTool:GraphLogY, proc=DWS_Ads_CheckBox
	CheckBox GraphLogX pos={325,YPOS-15},title="Log X?", variable= root:Packages:GasAdsorptionTool:GraphLogX, proc=DWS_Ads_CheckBox
	//CheckBox wavelegend pos={325,YPOS+15},title="Wave legend?", variable= root:Packages:GasAdsorptionTool:wavelegend, proc=DWS_Ads_CheckBox,value=0
	CheckBox GraphErrors pos={325,YPOS-30},title="Error bars?", variable=root:Packages:GasAdsorptionTool:GraphErrors
	CheckBox GraphErrors proc=DWS_Ads_CheckBox
	YPOS=150	
	//Button Porosity,pos={65,180},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Porosity"
	Button Folderlegend,pos={65,195},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Folder Legend"
	setdatafolder root:Packages:GasAdsorptionTool
	String PckgDataFolder="GasAdsorptionTool"
	String PanelWindowName="AdsorptionGraph"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String  AllowedUserTypes="V*;D*"//"SLDPROFILE*;"//"*_par;" or "r*;"	
	String UserNameString="Use:"//"_par" or "qrs"
	String XUserTypeLookup="V*:P*;D*:R*"//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0
	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(1, 2)
	PopupMenu QvecDataName title="x-wave"
	PopupMenu IntensityDataName title="y-wave"
	PopupMenu ErrorDataName title="s-wave"
	PopupMenu SelectDataFolder title="Folder"
	 YPOS=7; XPOS=-20
	PopupMenu SelectDataFolder pos={XPOS,YPOS+23}
	PopupMenu IntensityDataName pos={XPOS,YPOS+75}
	PopupMenu QvecDataName pos={XPOS,YPOS+48}
	PopupMenu ErrorDataName pos={XPOS,YPOS+98}		
	CheckBox UseQRSData ,disable=1
	CheckBox UseUserDefinedData pos={2,2},value=1 
	Checkbox PV  pos={45,2},title="PV", variable=root:Packages:GasAdsorptionTool:UsePV,proc=DWS_Ads_CheckBox
	Checkbox DR  pos={78,2},title="DR", variable=root:Packages:GasAdsorptionTool:UseDR,proc=DWS_Ads_CheckBox
	
	CheckBox STP pos={250, YPOS+75},title="STP?", variable=root:Packages:GasAdsorptionTool:STP
	CheckBox Cylinder pos={250, YPOS+90},title="Cylinder?", variable=root:Packages:GasAdsorptionTool:STP
	CheckBox Adsorption pos={250, YPOS+105},title="Adsorption?", variable=root:Packages:GasAdsorptionTool:STP
end

Function LoadTristar3000()
	newdatafolder/o/s Root:temp
	
XLLoadWave/R=(G29,J200)/Q //must be .xlsx
	string name=S_filename
	name="G"+  RemoveEnding(name , ".xlsx")//	name[0,strlen(name)-6]
	
	//name=cleanupName(name,0)
	
	name=Getnamechanges(name)
	//name=cleanupName(name,0)
	Name=name[0,30]
	If(DataFolderExists("Root:"+name ))
		killdatafolder "Root:"+name 
	endif
	RenameDataFolder Root:temp, $name	
	
	string Pname="Pads_"+name[1,30]
	wave columnG,ColumnI,ColumnH,ColumnJ
	Note  ColumnG "Adsorption relative pressure, STP, cm3/g";Note  ColumnI "Desorption relative pressure, STP, cm3/g"
	Note  ColumnH "Desorption relative pressure, STP, cm3/g";;Note  ColumnJ "Desorption relative pressure, STP, cm3/g"
	duplicate/o ColumnG,$Pname;killwaves ColumnG
	Pname="Pdes_"+name[1,30]
	duplicate/o ColumnI,$Pname;killwaves ColumnI
	Pname="Vads_"+name[1,30]
	duplicate/o ColumnH,$Pname;killwaves ColumnH
	Pname="Vdes_"+name[1,30]
	duplicate/o ColumnJ,$Pname;killwaves ColumnJ
	killdatafolder/z header
	Newdatafolder/s header//header
	string path=S_Path
	name=S_filename
	XLLoadWave/R=(G2,J16)/COLT="T"/Q/A=header path+name

	string filename= "G"+RemoveEnding(S_filename , ".xlsx")+"_red"
	Newdatafolder/s ::$filename
	XLLoadWave/R=(BG29,BH100)/Q/A=BJH path+name//************Loacation depends on xlsx file
	//XLLoadWave/R=(BL29,BM100)/Q  path

	wave BJH0,BJH1
	Pname="PBJH_"+name[0,30]
	Pname=Pname[0,30]
	duplicate/o BJH0,$Pname;killwaves BJH0
	
	Pname="VBJH_"+name[0,30]
	Pname=Pname[0,30]
	duplicate/o BJH1,$Pname;killwaves BJH1
	wave dvwave=$Pname
	Note dvwave,"dP/dLog(P) cm3/g\r file name = "+ S_filename
end

Function LoadASAP2010()
	newdatafolder/o/s Root:temp
	
XLLoadWave/R=(A3,D200)/Q //must be .xlsx
	string name=S_filename
	name="G"+  RemoveEnding(name , ".xlsx")//	name[0,strlen(name)-6]
	name=Getnamechanges(name)
	Name=name[0,30]
	If(DataFolderExists("Root:"+name ))
		killdatafolder "Root:"+name 
	endif
	RenameDataFolder Root:temp, $name	
	string Pname="Pads_"+name[1,30]
	wave columnA,ColumnB,ColumnC,ColumnD
	Note  ColumnA "Adsorption relative pressure, STP, cm3/g";Note  ColumnB "Desorption relative pressure, STP, cm3/g"
	Note  ColumnC "Desorption relative pressure, STP, cm3/g";;Note  ColumnD "Desorption relative pressure, STP, cm3/g"
	duplicate/o ColumnA,$Pname;killwaves ColumnA
	Pname="Pdes_"+name[1,30]
	duplicate/o ColumnC,$Pname;killwaves ColumnC
	Pname="Vads_"+name[1,30]
	duplicate/o ColumnB,$Pname;killwaves ColumnB
	Pname="Vdes_"+name[1,30]
	duplicate/o ColumnD,$Pname;killwaves ColumnD
End

Function LoadASAP2010PoreDistribution()
		newdatafolder/o/s Root:temp
	
XLLoadWave/R=(A3,D200)/Q //must be .xlsx
	string name=S_filename
	name="D"+  RemoveEnding(name , ".xlsx")+"_red"//	name[0,strlen(name)-6]
	name=Getnamechanges(name)
	Name=name[0,30]
	string foldername="Root:"+name 
	killdatafolder/z $name
	RenameDataFolder Root:temp, $name	
	string Dname="Rads_"+name[1,30]
	wave columnA,ColumnB,ColumnC,ColumnD
	duplicate/o ColumnA,$Dname;killwaves ColumnA
	Dname="Dads_"+name[1,30]
	duplicate/o ColumnB,$Dname;killwaves ColumnB
	Dname="Rdes_"+name[1,30]
	duplicate/o ColumnC,$Dname;killwaves ColumnC
	Dname="Ddes_"+name[1,30]
	duplicate/o ColumnD,$Dname;killwaves ColumnD
End


end

function Kelvinpressure(Dk)
	variable Dk//
	variable gam=8.88e-3//Surface Tension of LN2(J/m2)
	variable VL= 3.468e25//(3/mol)  molar volume
	variable R=8.314e20 //J 2/K/mol/m2  gas constant
	variable T=77//K
	variable Prel=exp(-2*gam*VL/(Dk*R*T))
	print Prel	
end

Function BJH(V, PoverPo,method)
	//dx.doi.org/10.1021/jp4057362 | J. Phys. Chem. C  Equation (2)
	wave V, PoverPo//V in cm3/g
	variable method// 1=BJH,2=KJS
	variable gam=8.88e-3//Surface Tension of LN2(J/m2)
	variable VL= 3.468e25//(3/mol)  molar volume at 77K
	variable R=8.314e20 //J 2/K/mol/m2  gas constant
	variable T=77//K
	String Plotname
	NVAR STP=root:Packages:GasAdsorptionTool:STP//check if the STP box is checked
	SVAR datafolder=root:Packages:GasAdsorptionTool:DataFolderName//Data folder picked
	setdatafolder datafolder
	Sort PoverPo,PoverPo,V
	duplicate/o V,VLN2
	
	if(STP==1)
		VLN2=V*1.55E-03//Change STP to Liqid N2
	endif
	SVAR FolderName=root:Packages:GasAdsorptionTool:DataFolderName
	SVAR RWaveName=root:Packages:GasAdsorptionTool:IntensityWaveName
	SVAR QWaveName=root:Packages:GasAdsorptionTool:Qwavename
	SVAR sWaveName=root:Packages:GasAdsorptionTool:ErrorWaveName
	If (method==3||method==4)//3 = alpha-s   4= t-plot
			if (datafolderexists(datafolder))
				setdatafolder datafolder
				wave RWave=$Rwavename	
				wave QWave=$Qwavename
			endif
		
		If(!datafolderexists("root:LiChrospherStandard"))
			doalert 0, "LiChrospher data missing"
			abort
		endif
		wave PrelRef=root:LiChrospherStandard:Prel
		wave alphaSref=root:LiChrospherStandard:AlphaSwave
		
		variable npts=numpnts(VLN2); print "npts = " +num2str(npts)
	If(method==3)//alpha-S
		duplicate/o Rwave,alphS
		alphS=interp(qwave, PrelRef, alphaSref )//interp(x1, xwaveName, ywaveName )
		plotname="AlphaSPlot"
		dowindow/k $plotname
		Display  /K=1 /N=$plotname /W=(500,0,800,250) VLN2 vs alphS as "AlphaSplot"///W=(left,top,right,bottom )
		Label left "Volume (cm3/g)";DelayUpdate
		Label bottom "Alpha-S";DelayUpdate
		SetAxis bottom 0,*
		SetAxis left 0,*
		ModifyGraph mode(VLN2)=3,marker(VLN2)=8,msize(VLN2)=2
		Cursor/P A VLN2 0;Cursor/P B VLN2 3;Cursor/P/S=0 C VLN2 npts-5;Cursor/P/S=0 D VLN2 npts-1
		//Cursor/P A VLN2 0;Cursor/P B VLN2 19;Cursor/P/S=0 C VLN2 30;Cursor/P/S=0 D VLN2 36
		SetWindow kwTopWin,hook(microporefit)=CursorAlphasHookFunction
		Button Kill_alphaS_Graph,pos={40,5},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Kill Graph"

		Abort
	elseif(method==4)//teplot
		duplicate/o Rwave,nwave,twave
		nwave=0
		
		wave Vads_LiChosopher=root:LiChrospherStandard:Vads_LiChrosopher
		nwave=interp(qwave, PrelRef, Vads_LiChosopher)//volume of standard at Prel of sample
		twave=1.55e-3*nwave/(25e-4)//thickness in   25m2/g is SA of standard
		nwave=1.55e-3*nwave/(25e-4*3.54)//number of layers
		plotname="tPlot"
		dowindow/k $plotname
		Display  /K=1 /N=$plotname /W=(801,0,1100,250) VLN2 vs twave as "tplot"///W=(left,top,right,bottom )

		
		
		Label left "Volume (cm3/g)";DelayUpdate
		Label bottom "Layer thickness ()";DelayUpdate
		SetAxis bottom 0,*
		SetAxis left 0,*
		ModifyGraph mode(VLN2)=3,marker(VLN2)=8,msize(VLN2)=2
		 
		
		Cursor/P A VLN2 0;Cursor/P B VLN2 3;Cursor/P/S=0 C VLN2 npts-5;Cursor/P/S=0 D VLN2 npts-1
		SetWindow kwTopWin,hook(microporefit)=CursorTplothookFunction
		Button Kill_alphaS_Graph,pos={40,5},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Kill Graph"
		TextBox/C/N=text5/A=MC RWaveName
		Abort
	endif
		
	endif
	
	duplicate/o V,rK,Rpore,thick_KJS, thick_BJH //set up waves needed below
	plotname="BJHandKJS"
	rK=-2*gam*VL/(R*T*ln(PoverPo))//calculate kelvin radius using Eq (2)
	//method 1  and 2
		string prefix=rwavename[1,30]//set up names for the pore size distributions in case both ads and des waves
		prefix="R"+prefix+"_BJH"
		prefix=Getnamechanges(prefix)
		Duplicate/o V,$prefix
		wave R_BJH_PoreDist=$prefix
		prefix="D"+prefix[1,100]
		Duplicate/o V,$prefix
		Wave D_BJH_PoreDist=$prefix

		prefix=rwavename[1,30]//set up KJS waves
		prefix="R"+prefix+"_KJS"
		Duplicate/o V,$prefix
		wave R_KJS_PoreDist=$prefix
		prefix="D"+prefix[1,100]
		Duplicate/o V,$prefix
		Wave D_KJS_PoreDist=$prefix
	//Method 1 BJH
		Thick_BJH=3.54*(-5/ln(PoverPo))^(1/3)//   Equation (3)
		Rpore=rk+1*thick_BJH      // should be 2* thickness of the adsorbed layers for slit pores
		R_BJH_PoreDist=2*Rpore
		Differentiate  VLN2/X=R_BJH_PoreDist/D= D_BJH_PoreDist//differentiate the VLN2 wave wrt Dpore and put the result in wave named PoreDist
		D_BJH_PoreDist*=2.303*R_BJH_PoreDist//dlog(x)=2.303 dln(x)
	//method 2 KJS
		thick_KJS=(60.65/(0.03071-log(PoverPo)))^0.3968 //   Equation (5)
		Rk=rk+3//fudge by 3   Equation (4)
		Rpore=rk+1*thick_KJS     // should be 2* thickness of the adsorbed layers for slit pores
		R_KJS_PoreDist =2*Rpore
		Differentiate  VLN2/X=R_KJS_PoreDist /D=D_KJS_PoreDist//differentiate the VLN2 wave wrt Dpore and put the result in wave named PoreDist
		D_KJS_PoreDist*=2.303*R_KJS_PoreDist //dlog(x)=2.303 dln(x)
	dowindow/k cum  //set up the cummulative plot by killing existing plot
		Display  /K=1 /N=cum /W=(500,0,900,250) VLN2 vs R_BJH_PoreDist as "BJTcumPlot"///W=(left,top,right,bottom )
		WaveStats/Q VLN2
		cursor A  VLN2  (V_npnts/2.1);cursor B  VLN2  (V_npnts/1.5)
		Appendtograph VLN2 vs R_KJS_PoreDist 
		ModifyGraph log(bottom)=1		
		ModifyGraph rgb(VLN2#1)=(0,0,0)
		Label left "Volume LN2 adsorbed (cm3/g)";DelayUpdate
		Label bottom "Pore Diameter()"
		
	dowindow/k $plotname//set up pore-size distribution plot
		Display  /K=1 /N=$plotname/W=(500,350,900,600) D_BJH_PoreDist vs R_BJH_PoreDist as plotname	///W=(left,top,right,bottom )
		wavestats/Q  D_BJH_PoreDist
		string trace=StringFromList(0, TraceNameList("",";",1),";")
		cursor A   $trace(V_maxloc-4);cursor B  $trace(V_maxloc+4)
		Tag/C/N=texta/A=RT $trace,V_maxloc,"BJH"
		
		Appendtograph  D_KJS_PoreDist vs R_KJS_PoreDist 
		//appendtograph/R Thick_BJH vs R_BJH_PoreDist;Label right "BJH Thickness ()"
		trace=StringFromList(1, TraceNameList("",";",1),";")
		ModifyGraph rgb($trace)=(0,0,0)
		Label left "dV/d(log(Dpore) (cm3/g)";DelayUpdate
		Label bottom "Pore Diameter ()";DelayUpdate
		SetAxis left 0,*
		ModifyGraph log(bottom)=1
		ModifyGraph mode=4//lines and markers
		SetAxis bottom *,300
		Button Porosity,pos={40,5},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Porosity"
		Button Folderlegend,pos={40,20},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Folder Legend"
		Legend/C/N=text5
		wavestats/Q D_KJS_PoreDist
		Tag/C/N=textb/A=RT $trace,V_maxloc ,"KJS"
		killwaves/z Rpore,rK,thick_BJH,Dpore,thick_KJS
end


function BdBFHH()
		SVAR Vwave=root:Packages:GasAdsorptionTool:IntensityWaveName
		SVAR PoverPo=root:Packages:GasAdsorptionTool:Qwavename
		NVAR STP=root:Packages:GasAdsorptionTool:STP
		NVAR Cylinder=root:Packages:GasAdsorptionTool:Cylinder
		NVAR Adsorption=root:Packages:GasAdsorptionTool:Adsorption
	      SVAR datafolder=root:Packages:GasAdsorptionTool:DataFolderName
		string plotname
		
		wave V = $Vwave
		wave Pr = $PoverPo


		

//		variable rp//pore radius
//		variable tl// layer thickness
//		variable gam=8.88e-3//Surface Tension of LN2(J/m2)
//	      variable VL= 3.468e25//(3/mol)  molar volume at 77K
//	      variable R=8.314e20 //J 2/K/mol/m2  gas constant
//	      variable T=77//K
	     variable alpha=5*(3.54)^3//depends on adsorbate and adsorbent
//	      variable f=0
//	      wave V=$vwave
	      duplicate/o V,VLN2
	 	
	 	if(STP==1)
		VLN2=V*1.55E-03//Change STP to Liqid N2
	endif
	 	
	 	if (Cylinder==1)
//		f=1
		else
//		f=2
	endif
	
	//if(Adsorption==1)
	variable a = 5 * (3.541 ^ 3)
	variable R = 0.8314
	variable T = 77.2
	variable RT = R * T
	variable gamm = 8.72
	variable Vm = 34.68
	variable factoroot = 2 * gamm * Vm / (R * T)
	variable factory = factoroot
	
	wave Vl
	duplicate/o V Vl
	Vl= 0.0015468 * V

	variable logprel, x, theta, root2, I, q,b,d
	wave Tcr, Rcr, Tave, Pave, Rave

	variable pts=numpnts(V)
	
	For(I = 0; I <= pts-1; I+=1)
       logprel = Log(Pr(I))
        q = -((alpha * factory / 3) ^ 0.5) / logprel
        R = alpha / (2 * logprel)
        If (R ^ 2 < q ^ 3)
            x = R / Sqrt(q ^ 3)
            theta = Atan(-x / Sqrt(-x * x + 1)) + 1.5708
            root2 = -2 * Sqrt(q) * Cos((theta + 2 * 3.14159) / 3)
            Tcr[I] = root2
        Else
            a = -Sign(R) * (Abs(R) + Sqrt(R ^ 2 - q ^ 3)) ^ (1 / 3)
            b = q / a
            Tcr[I] = a + b
        EndIf
        Rcr[I] = Tcr[I] + factory / (-logprel - alpha / Tcr[I] ^ 3)
    Endfor

For(I = 0; I<=pts-2; I+=1)
    Rave[I] = (Rcr[I] + Rcr[I + 1]) * Rcr[I] * Rcr[I + 1] / (Rcr[I] ^ 2 + Rcr[I + 1] ^ 2)
    a = Sqrt(factory)
    b = Sqrt(3 * alpha)
    d = -Rave[I] * b
    q = -0.5 * (b + Sign(b) * Sqrt(b ^ 2 - 4 * a * d))
    Tave[I] = d / q
    Pave[I] = Exp(-(factory / (Rave[I] - Tave[I]) + alpha / Tave[I] ^ 3))
   Endfor	

variable C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, J, K, f, df, dx
 variable Rcrit, Plog, Prel
 Make/O/N=(30, 2) Te
 
 C2 = alpha
 C3 = 0
 For(I = 1;  I<=pts-1; I+=1)
    Rcrit = Rave[I - 1]
    C1 = -alpha * Rcrit
    T = Tcr[I]
    For(J = I + 1; J<=pts; J+=1)
        Prel = Pr[J - 1]
        Plog = -Log(Prel)
        C5 = -Plog
        C4 = Rcrit * Plog - factory
        For (K = 1; K<=20; K+=1)
            f = C1 + T * (C2 + T ^ 2 * (C4 + T * C5))
            df = C2 + T * (T * (3 * C4 + T * 4 * C5))
            dx = f / df
            T = T - dx
//           print T
//            If (Abs(dx) < 0.0000000001) 
//            return 0 //NOT SURE HOW TO TERMINATE LOOP FOR
//            endif
        Endfor
        Te[J - 1][ I - 1] = T
    Endfor
Endfor	

wave Vd, Lp, Vc, Csa, PoreV
//duplicate/o V Vd Lp Vc Csa PoreV
String PoreType ="s"


For(I = 0; I<=pts-2; I+=1) 
    Vd[I] = 0
    If (I == 1)
        Vd[I]= 0
    Else
        For(J = 1; J<=I-1; J+=1)
//        If (cmpstr(PoreType, "s" )==0)
            Vd[I]= Vd[I] + 1e-24 * (4 / 3) * Pi * ((Rave[J] - Te[I + 1] [ J]) ^ 3 - (Rave[J] - Te[I][J]) ^ 3) * Lp[J]
 //     print Vd[I]
//        Else
//        If(cmpstr(PoreType, "c"))
//            Vd[I] = Vd[I] + 1E-16 * Pi * ((Rave[J] - Te[I + 1][J]) ^ 2 - (Rave[J] - Te[I][J]) ^ 2) * Lp[J]
//        EndIf
//        EndIf
       Endfor
 	EndIf

 If (Vd[I] >(Vl[I+1] - Vl[I]) )
        Lp[I] = 0
        Vc[I]= 0
       Csa[I] = 0
    Else
        Vc[I] = Vl[I] - Vl[I + 1] - Vd[I]
//        If(cmpstr(PoreType,"s"))
            Csa[I] = 4E-24 * (Pi / 3) * (Rave[I] - Te[I + 1][ I]) ^ 3
//        Else
//            If(cmpstr(PoreType,"c"))
//                Csa[I] = Pi * 1E-16 * (Rave[I] - Te[I + 1][ I]) ^ 2
 //           EndIf
//        EndIf
        Lp[I] = Vc[I] / Csa[I]
    EndIf
// 	If (cmpstr(PoreType,"s"))
        PoreV[I] = abs(4E-24 * (Pi / 3) * Lp[I] * Rave[I] ^ 3)
//      Else
//        If (cmpstr(PoreType, "c"))
 //           PoreV[I] = 1E-16 * Lp[I] * Pi * Rave[I] ^ 2
 //       EndIf
 //   EndIf
Endfor


//FindRoots 
 
	//ln(p0overp)-alpha/t^3=(f*gam*VL)/R*T*(rp-tl)
	//(3*alpha)/t^4=(f*gam*VL)/R*T*(rp-tl)^2
	//else
	//solve
	
	//ln(p0overp)-alpha/t^3=(f*gam*VL)/R*T*(rp-tl)
	//ln(p0overp)-alpha/r*t^2=(2*gam*VL)/R*T*(rp-tl)           //choose r grater than zero and also greater than t
	
	//endif
		
		
		
//		R_BdB_PoreDist=2*rp
//		Differentiate  VLN2/X=R_BdB_PoreDist/D= D_BdB_PoreDist
//		D_BdB_PoreDist*=2.303*ln(R_BdB_PoreDist)
		wave R_BdB_PoreDist//this wave does not exist, must duplicate a wave of same rank, like V
		wave D_BdB_PoreDist
		duplicate/o Rave R_BdB_PoreDist
		duplicate/o Rave D_BdB_PoreDist
		
		R_BdB_PoreDist = 2*Rave
		D_BdB_PoreDist = PoreV
				
		plotname="BdB-FHH"
		
	      dowindow/k $plotname//set up pore-size distribution plot
		Display  /K=1 /N=$plotname/W=(500,350,900,600) D_BdB_PoreDist vs R_BdB_PoreDist as plotname	///W=(left,top,right,bottom )
		wavestats/Q  D_BdB_PoreDist
		string trace=StringFromList(0, TraceNameList("",";",1),";")
		cursor A   $trace(V_maxloc-4);cursor B  $trace(V_maxloc+4)
		Tag/C/N=texta/A=RT $trace,V_maxloc,"BJH"
		
//		Appendtograph  D_BdB_PoreDist vs R_BdB_PoreDist 
		trace=StringFromList(1, TraceNameList("",";",1),";")
		ModifyGraph rgb($trace)=(0,0,0)
		Label left "dV/d(log(Dpore) (cm3/g)";DelayUpdate
		Label bottom "Pore Diameter ()";DelayUpdate
		SetAxis left 0,*
		ModifyGraph log(bottom)=1
		ModifyGraph mode=4//lines and markers
		SetAxis bottom *,300
		Button Porosity,pos={40,5},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Porosity"
		Button Folderlegend,pos={40,20},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Folder Legend"
		Legend/C/N=text5
		wavestats/Q D_BdB_PoreDist
//		Tag/C/N=textb/A=RT $trace,V_maxloc ,"KJS"
//		killwaves/z Rpore,rK,thick_BJH,Dpore,thick_KJS
end

	
function BET()
		SVAR RWaveName=root:Packages:GasAdsorptionTool:IntensityWaveName
		SVAR QWaveName=root:Packages:GasAdsorptionTool:Qwavename
		wave Rwave=$RwaveName;wave Qwave=$Qwavename
		sort Qwave,Qwave,Rwave
		duplicate/o Rwave,BETywave
		variable pts=numpnts(Rwave)
		Variable Vtot=Rwave(numpnts(Rwave)-1)
		BETywave=1/(Rwave*((Qwave^-1)-1))
		dowindow/k BETPlot
		FindLevel qwave, 0.5
		Display  /K=1 /N=BETPlot /W=(500,0,900,250) BETywave[0,V_LevelX] vs qwave[0,V_LevelX] as "BET Plot"//[0,14]
		Cursor A  BETywave  0; Cursor B  BETywave BinarySearch(Qwave, .15 )
		ModifyGraph mode(BETywave)=3,marker(BETywave)=8,msize(BETywave)=2
		SetAxis left 0,*;Label bottom "P/Po";Label left "1/V(Po/P-1) (g/cm3  STP)"
		Button Kill_alphaS_Graph,pos={40,5},size={70,16},font="Times New Roman",fSize=10,proc=DWS_AdsButtonProc,title="Kill Graph"
		SetWindow kwTopWin,hook(BETfit)=CursorBEThookFunction
	end


function FolderLegend()
	string trace
	trace=StringFromList(1, TraceNameList("",";",1),";")
	variable NumberofWaves=ItemsInList(tracenamelist("",";",1))
	variable counter=0
	string theFolder,TheText
	string list=TraceNameList("",";",1)
	theText="\Z12"	
	if(stringmatch(AnnotationList("AdsorptionGraph"),"*FolderLegend*"))//kill it if it exists
		TextBox/k/N=FolderLegend
		abort
	endif
	do
		string tracename=StringFromList(counter, list,";")//getstrfromlist (list, counter,";")	
		theFolder=GetWavesDataFolder(WaveRefIndexed("",counter ,1),0)
		theText=theText+ "\r\s("+tracename+")"
		theText=theText+thefolder//theFolder[0,(strlen(theFolder)-0)]
		counter+=1
	while(counter<Numberofwaves)
		TextBox/C/A=RT/N=FolderLegend/X=5.00/Y=12 theText	
End

function PorositybyIntegral()
		variable integral, totalporosity//cm3/g
		variable point=0.5*(pcsr(B)+Pcsr(A))
		string tracenameB =CsrWave(B,"",1), tracenameA =CsrWave(A,"",1)
		If(!stringmatch(tracenameA, TracenameB))
			doalert 0, "Cursors are not on the same trace"
			Abort
		endif
		string foldername =getdatafolder(1)//panel selection is not necessarilty the same as cursor wave
		setdatafolder GetWavesDataFolder(CsrWaveref(A),1 )
		string ywavename=CsrWave(A)
		string xwavenam=CsrXWave(A)
		wave ywave=$ywavename
		wave xwave=$xwavenam
		
		duplicate/o ywave,integrand
		duplicate/o xwave,logxwave
		logxwave=log(xwave)
		integrand=ywave/(2.303*xwave)
			variable bk= 0.5*(vcsr(B)+vcsr(A))*(logxwave[pcsr(B)]-logxwave[pcsr(A)])	
		integral=areaXY(logxwave, ywave,  logxwave[pcsr(A)],logxwave[pcsr(B)])//-bk
		totalporosity=areaXY(logxwave, ywave)	
		Tag/C/N=text232/L=2/A=MT/X=-15.00/Y=-3.00 $tracenameA, point,  num2str(integral)+" cm3/g"//\rTotal = "+num2str(totalporosity)+" cm3/g"
		// bk
		killwaves/z logqwave,integrand,logxwave
		setdatafolder foldername
	end
	
	Function CursorAlphasHookFunction(s)
	STRUCT WMWinHookStruct &s

	Variable hookResult = 0
	wave VLN2;wave alphS
	switch(s.eventCode)
		case 7:
		//	"cursormoved"	See Cursors - Moving Cursor Calls Function.
		//calculate micro pore line
			CurveFit/Q/M=2/W=0 line, VLN2[pcsr(A),pcsr(B)]/X=alphS[pcsr(A),pcsr(B)]/D
			wave W_coef
			variable SA_tot
			Tag/C/N=text0/A=MC/X=30/Y=0  VLN2, pcsr(A),"Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])		
			variable endpt=hcsr(B)		
			Make/N=10/o microwave; SetScale/I x, 0, endpt,microwave
			RemoveFromGraph/Z microwave
			appendtograph microwave		
			microwave = poly(W_coef, x)
			ModifyGraph rgb(microwave)=(0,0,0)
			variable slope =W_coef[1]
			variable icpt=W_coef[0]
			variable SBETref=25//m2/g
			variable VatPoverPoispoint4=9.12*1.55e-3// cm3 LN2/g  
			SA_tot=slope*SBETref/VatPoverPoispoint4
			string tagstring="SAtot= "+num2str(SA_tot)+" m2/g"	
			tagstring+="\rVmicro = "+num2str(W_coef[0])+" cm3/g"
			Tag/C/N=text0/A=MC/X=30/Y=0  VLN2, pcsr(A),tagstring
			
			//calculalte macropore line
			CurveFit/Q/M=2/W=0 line, VLN2[pcsr(C),pcsr(D)]/X=alphS[pcsr(C),pcsr(D)]/D
			//string tagstring2="Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])+"\r"
			
			endpt=hcsr(D)		
			Make/N=10/o macrowave; SetScale/I x, 0, endpt,macrowave
			RemoveFromGraph/Z macrowave
			appendtograph macrowave		
			macrowave = poly(W_coef, x)
			ModifyGraph rgb(macrowave)=(0,0,0)
			hookResult = 1	
			RemoveFromGraph/z fit_VLN2
			wave fit_VLN2;wave W_sigma;wave W_coef
			variable Vprimeso=W_coef[0]-icpt
			variable SA_EX=W_coef[1]*SBETref/VatPoverPoispoint4
			Tag/C/N=text1/A=MC/X=10/Y=-20.00  VLN2, pcsr(C),"SAext = "+num2str(SA_EX)+"m2/g\rVprimeso = "+num2str(Vprimeso)+" cm3/g"
			killwaves W_coef,W_sigma,fit_VLN2
			Killvariables/z V_flag
			
			hookResult = 1	
			break
	endswitch
	return hookResult		// 0 if nothing done, else 1
end


Function CursorTplotHookFunction(s)
	STRUCT WMWinHookStruct &s

	Variable hookResult = 0
	wave VLN2;wave twave
	switch(s.eventCode)
		case 7:
		//	"cursormoved"	See Cursors - Moving Cursor Calls Function.
		//calculate micro pore line
			CurveFit/Q/M=2/W=0 line, VLN2[pcsr(A),pcsr(B)]/X=twave[pcsr(A),pcsr(B)]/D
			wave W_coef
			variable SA_tot
			Tag/C/N=text0/A=MC/X=30/Y=0  VLN2, pcsr(A),"Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])		
			variable endpt=hcsr(B)		
			Make/N=10/o microwavet; SetScale/I x, 0, endpt,microwavet
			RemoveFromGraph/Z microwavet
			appendtograph microwavet		
			microwavet = poly(W_coef, x)
			ModifyGraph rgb(microwavet)=(0,0,0)
			variable slope =W_coef[1]
			variable icpt=W_coef[0]
			SA_tot=(slope)*1e4//*********
			string tagstring//="Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])+"\r"
			tagstring="SAtot= "+num2str(SA_tot)+" m2/g"	
			tagstring+="\rVmicro = "+num2str(W_coef[0])+" cm3/g"
			Tag/C/N=text0/A=MC/X=30/Y=0  VLN2, pcsr(A),tagstring
			
			//calculalte macropore line
			CurveFit/Q/M=2/W=0 line, VLN2[pcsr(C),pcsr(D)]/X=twave[pcsr(C),pcsr(D)]/D
			string tagstring2="Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])+"\r"
			
			endpt=hcsr(D)		
			Make/N=10/o macrowavet; SetScale/I x, 0, endpt,macrowavet
			RemoveFromGraph/Z macrowavet
			appendtograph macrowavet		
			macrowavet = poly(W_coef, x)
			ModifyGraph rgb(macrowavet)=(0,0,0)
			hookResult = 1	
			RemoveFromGraph/z fit_VLN2
			wave fit_VLN2;wave W_sigma;wave W_coef
			variable Vprimeso=W_coef[0]-icpt
			variable SA_EX=(W_coef[1])*1e4//*********
			Tag/C/N=text1/A=MC/X=10/Y=-20.00  VLN2, pcsr(C),"SAext = "+num2str(SA_EX)+"m2/g\rVprimeso = "+num2str(Vprimeso)+" cm3/g"
			killwaves W_coef,W_sigma,fit_VLN2
			Killvariables/z V_flag
			
			hookResult = 1	
			break
	endswitch
	return hookResult		// 0 if nothing done, else 1
end


Function CursorBETHookFunction(s)
	STRUCT WMWinHookStruct &s
	SVAR Qwavename=root:Packages:GasAdsorptionTool:QWavename
	wave PoverPo=$Qwavename
	Variable hookResult = 0
	wave BETyWave
	switch(s.eventCode)
		case 7:
			CurveFit/Q/NTHR=0 line  BETywave[pcsr(A),pcsr(B)] /X=PoverPo/D 
			wave W_coef
			variable endpt=hcsr(B)		
			Make/N=10/o BETfit; SetScale/I x, 0, endpt,BETfit
			RemoveFromGraph/Z BETfit
			appendtograph BETfit		
			BETfit = poly(W_coef, x)
			ModifyGraph rgb(BETfit)=(0,0,0)
			variable slope =W_coef[1]
			variable icpt=W_coef[0]	
			Variable Vm=1/(W_coef[1]+W_coef[0])
			Variable c=1+(W_coef[1]/W_coef[0])
			Variable SA_BET=(Vm*6.023E23*0.162E-18)/22414
			string tagstring="BET=  "+Num2str(SA_BET)+" m2/g"	//\r"Intercept = "+num2str(W_coef[0])+"\rSlope = "+num2str(W_coef[1])	+"\r
			Tag/C/N=text0/A=MC/X=30/Y=0  BETyWave, pcsr(B),tagstring
			SetAxis left 0,*;Label bottom "P/Po";Label left "1/V(Po/P-1) (g/cm3  STP)"
			killwaves W_coef
			Killvariables/z V_flag,W_sigma
			hookResult = 1	
			break
	endswitch
	return hookResult		// 0 if nothing done, else 1
end


Function  DWS_AdsSetVariableControl(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	IF(cmpstr(ctrlName,"ErrorMult")==0)
		DWS_Ads_Error_Gen()
	endif

end


function DWS_Ads_Error_Gen()
		SVAR FolderName=root:Packages:GasAdsorptionTool:DataFolderName
		setdatafolder Foldername
		SVAR RWaveName=root:Packages:GasAdsorptionTool:IntensityWaveName
		wave rwave=$rwavename
		SVAR SWaveName=root:Packages:GasAdsorptionTool:ErrorWaveName
		NVAR mult= root:Packages:GasAdsorptionTool:ErrorMultiplier
		if (!Waveexists($swavename))
			Swavename="S"+Rwavename[1,100]
		endif
		IN2G_GenerateSASErrors($Rwavename,$Swavename,4,.06, .01,Mult,3)// second to last is most important
			//(IntWave,ErrWave,                                   Pts_avg,Pts_avg_multiplier, IntMultiplier,MultiplySqrt,Smooth_Points)
				//this function will generate some kind of SAXS errors using many differnt methods... 
				// formula E = IntMultiplier * R + MultiplySqrt * sqrt(R)
				// E += Pts_avg_multiplier * abs(smooth(R over Pts_avg) - R)
				// min number of poitns is 3
			DWS_Ads_AttachErrorBars()
		
end

Function  DWS_Ads_SetVariableControl(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	IF(cmpstr(ctrlName,"ErrorMult")==0)
		DWS_Ads_Error_Gen()
	endif

end
	

function DWS_Ads_AttachErrorBars()
	SVAR folderpath=root:Packages:GasAdsorptionTool:DataFolderName
	SVAR rwavename=root:Packages:GasAdsorptionTool:IntensityWaveName
	SVAR swavename=root:Packages:GasAdsorptionTool:ErrorWaveName
	string tracename
	setdatafolder folderpath
	string tracelist=TraceNameList("AdsorptionGraph", ";", 1 )
		 tracename=StringFromList(0, tracelist,";")
	If (!stringmatch(tracename, "" ))
		if ((waveexists($swavename))&&(waveexists($rwavename)))
			ErrorBars/T=0 $rwavename Y,wave=( $swavename, $swavename);DelayUpdate
		endif
	endif	
		

end




Function DWS_AdsButtonProc(ctrlName) : ButtonControl
	String ctrlName
	SVAR basename=root:Packages:GasAdsorptionTool:basename
	SVAR FolderName=root:Packages:GasAdsorptionTool:DataFolderName
	SVAR RWaveName=root:Packages:GasAdsorptionTool:IntensityWaveName
	SVAR QWaveName=root:Packages:GasAdsorptionTool:Qwavename
	SVAR sWaveName=root:Packages:GasAdsorptionTool:ErrorWaveName
	NVAR csrAvg=root:Packages:GasAdsorptionTool:csravg
	NVAR GraphLogY=root:Packages:GasAdsorptionTool:GraphLogY
	NVAR GraphLogX=root:Packages:GasAdsorptionTool:GraphLogX
	
	
	string  Thenote,tracename//thefolder,thetext="",list,N,M
	variable counter = 0,NumberofWaves,background,start,step
	string wavenote, cmd,text,newname,savename,newfolder
	//setdatafolder DataFoldername
		
	
	if (datafolderexists(Foldername))
			setdatafolder foldername
			wave RWave=$Rwavename	
			wave QWave=$Qwavename
			wave SWave=$Swavename
			SVAR basename=basename
	Endif
	IF(cmpstr(ctrlName,"Kill_alphaS_Graph")==0)
		dowindow/k AlphaSplot
		killwaves/z microwave,macrowave,alphs,VLN2
		dowindow/k tPlot
		killwaves/z microwavet,macrowavet,VLN2,nwave,twave
		dowindow/k BETPlot
		killwaves/z BETywave, fit_BETywave, BETfit, W_sigma
	endif

	IF(cmpstr(ctrlName,"BdBFHHButton")==0)
		BdBFHH()
	ENDif
	
	IF(cmpstr(ctrlName,"BETButton")==0)
		BET()
	ENDif

	IF(cmpstr(ctrlName,"Porosity")==0)
		PorositybyIntegral()
	endif
	
	IF(cmpstr(ctrlName,"Loadtext")==0)
		load1d(1,2,2,-1,0,2,".txt",1)
	endif
	IF(cmpstr(ctrlName,"Folderlegend")==0)
		Folderlegend()
	endif
	IF(cmpstr(ctrlName,"Tristar")==0)
		LoadTristar3000()
	endif
	
	IF(cmpstr(ctrlName,"ASAP")==0)
		LoadASAP2010()
	endif
	
	IF(cmpstr(ctrlName,"ASAPDist")==0)
		LoadASAP2010PoreDistribution()
	endif
	
	if ((cmpstr(ctrlName,"generrors")==0)|| (cmpstr(ctrlName," ErrorMult")==0))//makes dummy error wave
			DWS_Ads_Error_Gen()
	endif

	IF(cmpstr(ctrlName,"BJH")==0)
		BJH(rwave, qwave,1)
	endif
	
	IF(cmpstr(ctrlName,"KJS")==0)
		BJH(rwave, qwave,2)
	endif
	
	IF(cmpstr(ctrlName,"alphaS")==0)
		BJH(rwave, qwave,3)
	endif
	
	
	IF(cmpstr(ctrlName,"tplot")==0)
		BJH(rwave, qwave,4)
	endif
	
	IF(cmpstr(ctrlName,"RemoveAdstrace")==0)
		string tracelist=TraceNameList("AdsorptionGraph", ";", 1 )
		 tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif
	endif	
		
	
	IF(cmpstr(ctrlName,"PlotAdsData")==0)	
		setdatafolder  FolderName
			if (waveexists(rwave))
		
			Appendtograph/W=AdsorptionGraph RWave vs qwave
//			DWS_AttachErrorBars(1)
			else
				doalert 0, "Pick the waves"
				abort
			endif
		
		wave yavedataa
		TheNote=note(qwave)
			start=LocateValue(Rwavename, .9,1,2)
		WaveStats/Q $rwavename
		cursor A  $rwavename (V_npnts/2.1);cursor B  $rwavename  (V_npnts/1.5)
		Legend/C/N=text1
	 	setaxis/A
	 	NVAR STP=root:Packages:GasAdsorptionTool:STP
		If (StringMatch(rwavename, "V*" ))
			IF(STP==1)
				Label left "\Z14\f01\F'arial'Volume cm\S3\M\Z14(STP)/g"
			ELSE
				Label Left "\Z14\f01\F'arial'Volume cm\S3\M\Z14(77K)/g"
			ENDIF
			Label bottom "\\Z14\\f01\\F'Times New Roman'P/Po"
		Elseif  (StringMatch(rwavename, "D*" ))
			Label Left "\Z14\f01\F'arial'dV/dlog(R)"
			Label bottom "\\Z14\\f01\\F'Times New Roman'R()"
		ENDIF
		TextBox/K/N=FolderLegend	
			
		ModifyGraph log(left)=graphlogy	
		ModifyGraph log(bottom)=graphlogX	
			FormatGraph(1)	
		endif		
end


Function DWS_Ads_CheckBox(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	string folder=getdatafolder(1)
	SVAR 	ListOfGraphFormating=root:Packages:GeneralplottingTool:ListOfGraphFormating
	NVAR GraphErrors=root:Packages:GasAdsorptionTool:GraphErrors
	SVAR 	Rwavename=root:Packages:GasAdsorptionTool:IntensityWaveName
	if (cmpstr("GraphLogX",ctrlName)==0)
		//anything needs to be done here?
		ListOfGraphFormating=ReplaceStringByKey("log(bottom)",ListOfGraphFormating, num2str(checked),"=")
		ModifyGraph log(bottom)=checked	
	endif	
	if (cmpstr("DR",ctrlName)==0||cmpstr("PV",ctrlName)==0)
 		NVAR/Z SetTimeOfUserDefFoldersStr = $("root:Packages:GasAdsorptionTool:SetTimeOfUserDefFoldersStr")
          if(NVAR_Exists(SetTimeOfUserDefFoldersStr))
          	SetTimeOfUserDefFoldersStr=0
          endif
		SVAR usertypes=root:Packages:IrenaControlProcs:ControlAllowedUserTypes
		NVAR USEPV=root:Packages:GasAdsorptionTool:UsePV
		NVAR UseDR=root:Packages:GasAdsorptionTool:UseDR
		userTypes=""
		if (UsePV==1)
			Usertypes= "AdsorptionGraph=V*>"
			if (UseDR==1)
				  Usertypes=usertypes+"AdsorptionGraph=V*;D*>"
			endif
		Elseif  (UseDR==1)
		
			Usertypes= "AdsorptionGraph=D*>"
		Endif
		
		
		
		
	Endif
	if (cmpstr("GraphLogy",ctrlName)==0)
		ListOfGraphFormating=ReplaceStringByKey("log(left)",ListOfGraphFormating, num2str(checked),"=")
		ModifyGraph log(left)=checked
	endif	
	if (cmpstr("GraphErrors",ctrlName)==0)
		if (GraphErrors==1)
		 	DWS_Ads_AttachErrorBars()
		 else
		 	ErrorBars $Rwavename OFF 
		endif
	endif	
	if (cmpstr("wavelegend",ctrlName)==0)
		Legend/C/N=text0/A=RB
	endif
end
